<?php
include "konekbuku.php";

// ambil keyword pencarian
$keyword = $_GET['keyword'] ?? '';

// amankan keyword
$keyword = mysqli_real_escape_string($conn, $keyword);

// query dengan pencarian
if ($keyword != '') {
    $sql = "
        SELECT * FROM buku 
        WHERE id_buku LIKE '%$keyword%'
        OR isbn LIKE '%$keyword%'
        OR judul LIKE '%$keyword%'
        OR pengarang LIKE '%$keyword%'
        OR penerbit LIKE '%$keyword%'
        OR lokasi LIKE '%$keyword%'
    ";
} else {
    $sql = "SELECT * FROM buku";
}

$buku = mysqli_query($conn, $sql);

// CEK QUERY
if (!$buku) {
    die("Query error: " . mysqli_error($conn));
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Perpustakaan SMK PEMKAB</title>
    <link rel="stylesheet" href="buku.css">
</head>
<body>
<p class="footer-text">
       <center><button> <a href="logout.php">LOGOUT</a></button></center>
<div class="container mt-4">
    <h3 class="text-center mb-4">Daftar Koleksi Buku</h3>

    <!-- FORM PENCARIAN -->
    <form method="GET" class="row mb-3">
        <div class="col-md-10">
            <input type="text" name="keyword" class="form-control"
                   placeholder="Cari buku..."
                   value="<?= htmlspecialchars($keyword); ?>">
        </div>
        <div class="col-md-2 d-grid">
            <button type="submit" class="btn btn-primary">🔍 Cari</button>
        </div>
    </form>

    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover">
            <thead class="table-primary text-center">
                <tr>
                    <th>ID Buku</th>
                    <th>ISBN</th>
                    <th>Judul</th>
                    <th>Pengarang</th>
                    <th>Penerbit</th>
                    <th>Tahun</th>
                    <th>Stok</th>
                    <th>Lokasi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (mysqli_num_rows($buku) > 0): ?>
                    <?php while ($row = mysqli_fetch_assoc($buku)): ?>
                        <tr>
                            <td><?= $row['id_buku']; ?></td>
                            <td><?= $row['isbn']; ?></td>
                            <td><?= $row['judul']; ?></td>
                            <td><?= $row['pengarang']; ?></td>
                            <td><?= $row['penerbit']; ?></td>
                            <td class="text-center"><?= $row['tahun_terbit']; ?></td>
                            <td class="text-center"><?= $row['stok']; ?></td>
                            <td class="text-center"><?= $row['rak']; ?></td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8" class="text-center text-danger">
                            Data buku tidak ditemukan
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
         <div class="col-md-2 d-grid">
            <button type="submit" class="btn btn-primary"> Pinjam Buku</button>
        </div>
    </div>
</div>

</body>
</html>
